<?php
require_once '../../config.php';
session_start();
header('Content-Type: application/json; charset=UTF-8');

// 1) validate inputs
if (
  empty($_GET['mac'])
  || !preg_match('/^([0-9A-Fa-f]{2}:){5}[0-9A-Fa-f]{2}$/', $_GET['mac'])
  || !isset($_GET['session'])
  || !ctype_digit($_GET['session'])
) {
  http_response_code(400);
  exit;
}
$mac     = $_GET['mac'];
$session = (int)$_GET['session'];

// 2) connect
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) { http_response_code(500); exit; }

// 3) compute Eastern‐time
$dt = new DateTime('now', new DateTimeZone('UTC'));
$dt->setTimezone(new DateTimeZone('America/New_York'));
$fmt = $dt->format('n/j/Y g:i A');

// 4) update heartbeat + last_ping_time
$stmt = mysqli_prepare($con, "
  UPDATE glance_scroll_tracking
     SET heartbeat       = heartbeat + 1,
         last_ping_time  = ?
   WHERE mac_address    = ?
     AND session_count  = ?
");
mysqli_stmt_bind_param($stmt, 'ssi', $fmt, $mac, $session);
mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

// 5) fetch new heartbeat & original session_starttime
$stmt = mysqli_prepare($con, "
  SELECT heartbeat, session_starttime
    FROM glance_scroll_tracking
   WHERE mac_address   = ?
     AND session_count = ?
");
mysqli_stmt_bind_param($stmt, 'si', $mac, $session);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $hb, $sessStart);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);
mysqli_close($con);


