<?php
require_once '../config.php'; // Common configuration file, adjusted path as needed
// Detecting the type of ticker being requested (crypto or stock)
$tickerInput = $_GET['ticker'];
$inputTicker = pathinfo($tickerInput, PATHINFO_FILENAME); // This removes the extension if present
$currType = isset($_GET['CurrType']) ? $_GET['CurrType'] : 'USD';
$currType_val = "USD-" . $currType;
$output_dir = "/home2/passive1/public_html/Scrolling/App_Output/Json/create_panel_crypto";
$logo_base_path = "/home2/passive1/getStockPanel/Logos/Crypto/";

// Establish database connection
try {
    $db = new PDO("mysql:host=$host;dbname=$database", $username, $password);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$isCrypto = true;
$table = $isCrypto ? 'crypto_database' : 'stock_list';

$stmt = $db->prepare("SELECT * FROM $table WHERE Ticker = :ticker");
$stmt->execute([':ticker' => $inputTicker]);
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    echo "No data found for ticker: $inputTicker\n";
    exit;
}

$price = $data[$isCrypto ? 'usd' : 'Price'];
$percent_change = $data[$isCrypto ? 'usd_24h_change' : '% Change'];

if ($currType != "USD") {
    $stmt = $db->prepare("SELECT * FROM $table WHERE Ticker = :ticker_val");
    $stmt->execute([':ticker_val' => $currType_val]);
    $conversionData = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($conversionData) {
        $convValue = $conversionData['Price'];
        $price *= $convValue;
        $price = number_format($price, 4);
    }
}

$price = number_format($price, 2, '.', '');
$percent_change = number_format($percent_change, 2, '.', '');
$logo_path = $logo_base_path . ($isCrypto ? str_replace("USD-", "", $inputTicker) : $inputTicker) . ".png";
$json_file_path = $output_dir . '/' . $inputTicker . '.json';

if (file_exists($json_file_path)) {
    generate_finance_image($output_dir, $inputTicker, $percent_change, $price, $logo_path, true);
} else {
    generate_finance_image($output_dir, $inputTicker, $percent_change, $price, $logo_path, true);
}


function generate_finance_image($panels_output_dir, $ticker, $percent, $price, $png_path, $saveImageFlag) {
    $width = 64;
    $height = 32;
    $image = imagecreatetruecolor($width, $height);
    $black = imagecolorallocate($image, 0, 0, 0);
    imagefill($image, 0, 0, $black);
    $png_image = imagecreatefrompng($png_path);
    $png_image_resized = imagescale($png_image, 22, 32);
    imagecopy($image, $png_image_resized, 0, 0, 0, 0, 22, 32);
    imagedestroy($png_image);

    $white = imagecolorallocate($image, 255, 255, 255);
    $green = imagecolorallocate($image, 0, 255, 0);
    $red = imagecolorallocate($image, 255, 0, 0);

    $font_path = '/home2/passive1/public_html/Scrolling/fonts/5x7-lcd.ttf'; // Path to a TrueType font
    $font_size = 6; // Font size

    $ticker_position_x = 23;
    $ticker_position_y = 8; // Adjust y position for better alignment
    $price_position_y = $height - 2; // Adjust y position for better alignment
    $percent_position_y = $height / 2 + 2; // Adjust y position for better alignment

    // Draw ticker
    imagettftext($image, $font_size, 0, $ticker_position_x, $ticker_position_y, $white, $font_path, "$" . $ticker);
    // Draw price
    imagettftext($image, $font_size, 0, $ticker_position_x, $price_position_y, $green, $font_path, "$" . $price);
    // Draw percent change
    $percent_text = (floatval($percent) > 0 ? "+" : "-") . abs($percent) . "%";
    $percent_color = (floatval($percent) > 0) ? $green : $red;
    imagettftext($image, $font_size, 0, $ticker_position_x, $percent_position_y, $percent_color, $font_path, $percent_text);

    $json_output = image_to_rgb565_json($image);
    $json_file_path = $panels_output_dir . '/' . $ticker . '.json'; // Use the provided directory path
    file_put_contents($json_file_path, $json_output); // Make sure to use the full path
    imagedestroy($image);

    // Echo out the JSON content
    // echo "New JSON Data:\n";
    echo json_encode(json_decode($json_output), JSON_PRETTY_PRINT);
}




function extract_new_image_data($image) {
    $width = imagesx($image);
    $height = imagesy($image);
    $image_data = [];
    for ($y = 0; $y < $height; $y++) {
        for ($x = 0; $x < $width; $x++) {
            $rgb = imagecolorat($image, $x, $y);
            $r = ($rgb >> 16) & 0xFF;
            $g = ($rgb >> 8) & 0xFF;
            $b = $rgb & 0xFF;

            // Convert RGB888 to RGB565
            $rgb565 = (($r & 0xF8) << 8) | (($g & 0xFC) << 3) | ($b >> 3);

            $image_data[] = $rgb565;
        }
    }
    return $image_data;
}

function image_to_rgb565_json($image) {
    $width = imagesx($image);
    $height = imagesy($image);
    $json_output = '{"Image":[';
    $firstPixel = true;
    for ($y = 0; $y < $height; $y++) {
        for ($x = 0; $x < $width; $x++) {
            $rgb = imagecolorat($image, $x, $y);
            $r = ($rgb >> 16) & 0xFF;
            $g = ($rgb >> 8) & 0xFF;
            $b = $rgb & 0xFF;

            // Convert RGB888 to RGB565
            $rgb565 = (($r & 0xF8) << 8) | (($g & 0xFC) << 3) | ($b >> 3);

            if (!$firstPixel) {
                $json_output .= ',';
            }
            $json_output .= $rgb565;
            $firstPixel = false;
        }
    }
    $json_output .= '],"String1":"","String2":""}';
    return $json_output;
}
?>
