<?php

function loadImageAndConvertToPixels() {
    $pngPath = '/home2/passive1/getStockPanel/Logos/Fun/WOD.png';
    $canvasWidth = 128;
    $canvasHeight = 32;

    // Create a blank true color image
    $image = imagecreatetruecolor($canvasWidth, $canvasHeight);

    // Fill the canvas with black (or any other base color)
    $black = imagecolorallocate($image, 0, 0, 0);
    imagefill($image, 0, 0, $black);

    // Load the PNG image
    $pngImage = imagecreatefrompng($pngPath);

    // Get dimensions of the PNG image
    $pngWidth = imagesx($pngImage);
    $pngHeight = imagesy($pngImage);

    // Calculate positioning to center the PNG image on the canvas
    $posX = ($canvasWidth - $pngWidth) / 2;
    $posY = 0 ;

    // Place the PNG image onto the canvas
    imagecopy($image, $pngImage, $posX, $posY, 0, 0, $pngWidth, $pngHeight);
    imagedestroy($pngImage); // Free up memory

    // Fetch  data
    $DATA = fetchData();

    // Convert to RGB565 and create JSON output
    $jsonOutput = image_to_rgb565_json($image, $DATA['word'] ?? '', $DATA['definition'] ?? '');
    imagedestroy($image); // Free up memory

    // Echo out the JSON content
    echo $jsonOutput;
}

function image_to_rgb565_json($image, $date, $fact) {
    $width = imagesx($image);
    $height = imagesy($image);
    $jsonOutput = '{"Image":[';
    $firstPixel = true;
    for ($y = 0; $y < $height; $y++) {
        for ($x = 0; $x < $width; $x++) {
            $rgb = imagecolorat($image, $x, $y);
            $r = ($rgb >> 16) & 0xFF;
            $g = ($rgb >> 8) & 0xFF;
            $b = $rgb & 0xFF;

            // Convert RGB888 to RGB565
            $rgb565 = (($r & 0xF8) << 8) | (($g & 0xFC) << 3) | ($b >> 3);

            if (!$firstPixel) {
                $jsonOutput .= ',';
            }
            $jsonOutput .= $rgb565;
            $firstPixel = false;
        }
    }
    $jsonOutput .= "],\"String1\":\"" . strtoupper($date) . "\",\"String2\":\"" . strtoupper($fact) . "\"}";
    return $jsonOutput;
}

function fetchData() {
    $url = "https://www.passiveincomeconsultingllc.com/fun/WOD.php";
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $output = curl_exec($ch);
    curl_close($ch);

    return json_decode($output, true);
}

loadImageAndConvertToPixels();

?>
