<?php
// CloudFlare Worker Proxy Test
// Your worker URL: https://lively-field-1cf7.growth-136.workers.dev/

$worker_url = 'https://lively-field-1cf7.growth-136.workers.dev';

echo "<h2>Testing VPS Connection Through CloudFlare Worker</h2>";
echo "Time: " . date('Y-m-d H:i:s') . "<br>";
echo "Worker URL: $worker_url<br>";
echo "<hr>";

// Test 1: Basic connectivity test
echo "<h3>Test 1: Basic VPS Homepage</h3>";
$test = @file_get_contents($worker_url . '/');
if ($test === false) {
    echo "❌ Cannot reach VPS through CloudFlare Worker<br>";
    echo "Error: " . error_get_last()['message'] . "<br>";
} else {
    echo "✅ SUCCESS! Can reach VPS web server through CloudFlare!<br>";
    echo "Response length: " . strlen($test) . " bytes<br>";
    // Show first 200 characters of response
    if (strlen($test) > 0) {
        echo "First 200 chars: <code>" . htmlspecialchars(substr($test, 0, 200)) . "...</code><br>";
    }
}

// Test 2: Your API endpoint
echo "<h3>Test 2: Glancescroll API</h3>";
$mac = 'F4:12:FA:84:B5:F1';
$profile = '1';
$api_url = $worker_url . '/glancescroll/API/get.php?mac=' . $mac . '&profile=' . $profile;

echo "Testing: $api_url<br>";
$api_test = @file_get_contents($api_url);
if ($api_test === false) {
    echo "❌ API call failed<br>";
    echo "Error: " . error_get_last()['message'] . "<br>";
} else {
    echo "✅ API call successful!<br>";
    echo "Response length: " . strlen($api_test) . " bytes<br>";
    echo "Response: <pre>" . htmlspecialchars($api_test) . "</pre>";
}

// Test 3: Comparison - Direct vs Proxied
echo "<h3>Test 3: Direct vs Proxied Comparison</h3>";
echo "<b>Direct to VPS (should fail):</b> ";
$direct = @file_get_contents('http://www.gscroll.us/');
if ($direct === false) {
    echo "❌ Blocked (expected)<br>";
} else {
    echo "✅ Working (unexpected!)<br>";
}

echo "<b>Through CloudFlare (should work):</b> ";
$proxied = @file_get_contents($worker_url . '/');
if ($proxied === false) {
    echo "❌ Failed<br>";
} else {
    echo "✅ Working!<br>";
}

echo "<hr>";
echo "<h3>How to use in your code:</h3>";
echo "<pre style='background:#f0f0f0; padding:10px;'>";
echo "// Instead of:\n";
echo "\$result = file_get_contents('http://www.gscroll.us/api/endpoint');\n\n";
echo "// Use:\n";
echo "\$result = file_get_contents('$worker_url/api/endpoint');\n\n";
echo "// For your database connection, create an API endpoint on your VPS\n";
echo "// Then call it through the worker like:\n";
echo "\$response = file_get_contents('$worker_url/mysql-api.php?action=query');\n";
echo "</pre>";
?>