<?php

require_once '../../config.php'; // Include configuration file
require_once '../../meekrodb.2.4.class.php';
require_once 'response.php';

// Set database connection
$db = new MeekroDB($host, $username, $password, $database);

// Set gscroll database connection
$db_gscroll = new MeekroDB($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


$table = 'glance_scroll';
$profileTable = 'glance_scroll_profile';
$ledTable = 'selected_coins';

if (isset($_GET['mac']) && isset($_GET['profile'])) {

    $mac = $_GET['mac'];
    $profile = $_GET['profile'];

    if (false === filter_var($mac, FILTER_VALIDATE_MAC)) {
        return response(400, 'Invalid MAC Address Entered. MAC address should be exactly 17 characters long. The MAC address should be in the format XX:XX:XX:XX:XX:XX');
    } else {
        $result = $db_gscroll->query("SELECT mac, selections, endpoint, profile FROM $table where mac = %s", $mac);

        if(empty($result)) {
            // check if its a SCROLL device
            $result = $db->query("SELECT * FROM $ledTable where dev_mac = %s", $mac);
            if(!empty($result)) {
                return response(400, 'This appears to be a GLANCE device. Please use the GLANCE CLASSIC option from the Home screen.');
            }
            return response(404, 'Unregistered MAC Address and Profile. Please Double Check Entry - Digits Range from 0-9 and A-F. Contact us at glance-led.com if issues persist.');
        } else {
            foreach ($result as $row) {
                if($row["profile"] === $profile) {
                    $responseData = Array("macAddress"=>$row["mac"]);
                    $responseData["profile"]=$row["profile"];
                    $arraySelections = explode(',', $row["selections"]);
                    $arrayEndpoint = explode(',', $row["endpoint"]);
                    parseResponse($responseData, $arraySelections, $arrayEndpoint);

                    // Get custom profile names and times
                    $profileResult = $db_gscroll->queryFirstRow("SELECT profileNames, profileTimes FROM $profileTable where mac = %s", $mac);
                    parseProfileResponse($responseData, $profileResult);
                    return response(200, $responseData);
                }

            }

            // Profile not found. Return empty response.
            $responseData = Array("macAddress"=>$mac);
            $responseData["profile"]=$profile;
            parseResponse($responseData, Array(), Array());
            return response(200, $responseData);

        }

    }

} else if (isset($_GET['default'])) {

    $responseData = Array("macAddress"=>"");
    $responseData["profile"]="1";
    parseResponse($responseData, Array(), Array());
    parseProfileResponse($responseData, Array());

    return response(200, $responseData);

} else {
    return response(400, 'MAC and Profile required.');
}


function parseResponse(&$responseData, $arraySelections, $arrayEndpoint) {

    include 'select_map.php';
    include 'endpoint_map.php';

    $stock = $crypto = $topMovers = $standings = $game = $team = $teamStats = $playerStats = $lifestyle = $worldClock = $weather = $freetext = $gifs = $openApps = Array();
    $timezone = $youtube = $instagram = $learnNewLanguage = $ledBrightness = $scrollSpeed = '';
    $weatherUnit = $powerBall = $megaMillion = $wordOfTheDay = $trivia = $todayInHistory = $dailyFacts = $flagOfTheDay = $greatQuotes = $sportsFact = $tish = $worldNews = $financeNews = $sportsNews = false;
    $sleepStartTime = $sleepEndTime = null;

    // Parse Selection
    foreach ($arraySelections as $item) {

        if(str_starts_with($item, '!')) {

            array_push($stock, Array("Ticker"=>str_ireplace('!', '', $item), "Name"=>""));

        } else if(str_starts_with($item, '*')) {

            array_push($crypto, Array("Ticker"=>str_ireplace('*', '', $item), "Name"=>""));

        } else if(str_starts_with($item, '^')) {

            array_push($team, str_ireplace('^', '', $item));

        } else if(str_starts_with($item, '}')) {

            array_push($worldClock, str_ireplace('}', '', $item));

        } else if(str_starts_with($item, '_')) {

            array_push($weather, substr(str_ireplace('_', '', $item), 0, -2));
            $weatherUnit = substr($item, -1)==="C"?true:false;

        } else if(str_starts_with($item, '-PB')) {

            $powerBall = true;

        } else if(str_starts_with($item, '-MM')) {

            $megaMillion = true;

        } else if(str_starts_with($item, '@') && str_ends_with($item, '|Youtube')) {

            $youtube = str_ireplace('|Youtube', '', $item);

        } else if(str_starts_with($item, '@') && str_ends_with($item, '|Instagram')) {

            $instagram = str_ireplace('|Instagram', '', $item);

        } else if(str_starts_with($item, '+TIAH.php')) {

            $todayInHistory = true;

        } else if(str_starts_with($item, '+FACT.php')) {

            $dailyFacts = true;

        } else if(str_starts_with($item, '+QUOTE.php')) {

            $greatQuotes = true;

        } else if(str_starts_with($item, '+SF.php')) {

            $sportsFact = true;

        } else if(str_starts_with($item, '+TISH.php')) {

            $tish = true;

        } else if(str_starts_with($item, '{TRIVIA.php')) {

            $trivia = true;

        } else if(str_starts_with($item, '{WOD.php')) {

            $wordOfTheDay = true;

        } else if(str_starts_with($item, '{LNL.php?in=')) {

            $learnNewLanguage = Array("value"=>str_ireplace('{LNL.php?in=', '', $item), "label"=>$learnNewLanguageMap[str_ireplace('{LNL.php?in=', '', $item)]);

        } else if(str_starts_with($item, 'CM_')) {

            array_push($freetext, Array("text"=>substr(str_ireplace('CM_', '', $item), 0, -2), "color"=>substr($item, -1)));

        } else if(str_starts_with($item, 'tz_')) {

            $timezone = Array("value"=>str_ireplace('tz_', '', $item), "label"=>$timezonesMap[str_ireplace('tz_', '', $item)]);

        } else if(str_starts_with($item, 'br_')) {

            $ledBrightness = str_ireplace('br_', '', $item);

        } else if(str_starts_with($item, 'ss_')) {

            $scrollSpeed = str_ireplace('ss_', '', $item);

        } else if(str_starts_with($item, 'st_')) {

            $sleepStartTime = adjustTime(str_ireplace('st_', '', $item));

        } else if(str_starts_with($item, 'se_')) {

            $sleepEndTime = adjustTime(str_ireplace('se_', '', $item));

        }

    }

    // Parse EndPoint only selection
    foreach ($arrayEndpoint as $item) {

        if(in_array($item, $standingMap)) {
            array_push($standings, array_search($item, $standingMap));
        } else if(in_array($item, $gameMap)) {
            array_push($game, array_search($item, $gameMap));
        } else if(in_array($item, $topMoversMap)) {
            array_push($topMovers, array_search($item, $topMoversMap));
        } else if(array_search($item, $endPointMap) === "FOD") {
            $flagOfTheDay = true;
        } else if(array_search($item, $endPointMap) === "WN") {
            $worldNews = true;
        } else if(array_search($item, $endPointMap) === "FN") {
            $financeNews = true;
        } else if(array_search($item, $endPointMap) === "SN") {
            $sportsNews = true;
        } else if(str_starts_with($item, 'GIF:')) {
            array_push($gifs, $item);
        } else if(str_starts_with($item, 'OA:')) {
            array_push($openApps, $item);
        } else if(str_starts_with($item, 'SS:')) {
            if(str_contains($item, '|TS_')) {
                array_push($teamStats, Array("mapping"=>$item, "name"=>""));
            } else if(str_contains($item, '|PS_')) {
                array_push($playerStats, Array("mapping"=>$item, "name"=>""));
            }

        }

    }

    // Set Defaults for empty fields
    $ledBrightness = empty($ledBrightness) ? $defaultMap["ledBrightness"] : $ledBrightness;
    $scrollSpeed = empty($scrollSpeed) ? $defaultMap["scrollSpeed"] : $scrollSpeed;

    // Build App Local Storage Objects
    $responseData["finance"]=Array("stock"=>$stock, "crypto"=>$crypto, "topMovers"=>$topMovers);
    $responseData["sports"]=Array("standings"=>$standings, "game"=>$game, "team"=>$team, "teamStats"=>$teamStats, "playerStats"=>$playerStats);
    $responseData["lifestyle"]=Array("worldClock"=>$worldClock, "weather"=>$weather, "weatherUnit"=>$weatherUnit, "powerBall"=>$powerBall, "megaMillion"=>$megaMillion, "youtube"=>$youtube, "instagram"=>$instagram);
    $responseData["fun"]=Array("wordOfTheDay"=>$wordOfTheDay, "trivia"=>$trivia, "todayInHistory"=>$todayInHistory, "dailyFacts"=>$dailyFacts, "flagOfTheDay"=>$flagOfTheDay,"greatQuotes"=>$greatQuotes, "sportsFact"=>$sportsFact, "tish"=>$tish, "learnNewLanguage"=>$learnNewLanguage);
    $responseData["news"]=Array("world"=>$worldNews, "finance"=>$financeNews, "sports"=>$sportsNews);
    $responseData["freetext"]=array_pad($freetext, 3, Array("text"=>'', "color"=>'w'));
    $responseData["gif"]=$gifs;
    $responseData["openApps"]=$openApps;
    $responseData["settings"]=Array("timezone"=>$timezone, "ledBrightness"=>$ledBrightness,"scrollSpeed"=>$scrollSpeed, "startTime"=>$sleepStartTime, "endTime"=>$sleepEndTime);

}

function parseProfileResponse(&$responseData, $result) {

    include 'endpoint_map.php';
    $profileNames = $defaultMap["profileNames"];
    $profileTimes = $defaultMap["profileTimes"];

    if(!empty($result)) {
        if(!empty($result['profileNames'])) {
            $profileNames=json_decode($result['profileNames']);
        }
        if(!empty($result['profileTimes'])) {
            $profileTimesFromDB = json_decode($result['profileTimes'], true);

            if(!empty($profileTimesFromDB)) {
                
                foreach ($profileTimesFromDB["profiles"] as $item) {
                    $profileItems = Array("profile" => $item["profile_id"]);
                    $profileItems["startTime"] = adjustTime($item["time"]);
                    
                    foreach($profileDayMap as $profileDay) {
                        $profileItems[substr($profileDay, 0, 3)] = in_array($profileDay, $item["days"]);
                    }

                    $index = array_search($item["profile_id"], array_column($profileTimes, "profile"));
                    $profileTimes[$index] = $profileItems;
                    
                }

            }

        }

    }

    $responseData["profileNames"] = $profileNames;
    $responseData["profileTimes"] = $profileTimes;
    
}

function adjustTime($time) {

    include 'endpoint_map.php';

    $dbTimeZone = new DateTimeZone($defaultMap["timeZone"]);
    $appTimeZone = new DateTimeZone("UTC");
    $date = null;

    if($time != null || !empty($time)) {

        $date = new DateTime();
        $date->setTimeZone($dbTimeZone);
        $date->modify($time);
        $date->setTimeZone($appTimeZone);
        $date = $date->format('Y-m-d') . 'T' . $date->format('H:i:s') . '.000Z';

    }

    return $date;

}

?>



