<?php
/**
 * QuickBooks API Configuration
 * This file contains shared configuration settings for the QuickBooks API integration
 */

// QuickBooks API credentials
$clientID = 'ABv2uUuyvU2rwVoRD4G79vS8qUhm2fB569wMLD6TUsbnge3VPG';         // From QuickBooks Developer dashboard
$clientSecret = 'wnGHGwV2meOIdheIVzdAx17uCKd3gUq2WRufOkyP'; // From QuickBooks Developer dashboard

// Application settings
$redirectURI = 'https://gscroll.us/finances2/auth_callback.php';
$scope = 'com.intuit.quickbooks.accounting';
$baseURL = 'Production'; // Use 'production' for live data

// Logging function
function logError($message, $data = null) {
    $logfile = 'quickbooks_errors.log';
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[{$timestamp}] {$message}";
    
    if ($data !== null) {
        $logMessage .= " - Data: " . print_r($data, true);
    }
    
    file_put_contents($logfile, $logMessage . PHP_EOL, FILE_APPEND);
}

// Check for required PHP extensions
$requiredExtensions = ['curl', 'openssl', 'json'];
foreach ($requiredExtensions as $ext) {
    if (!extension_loaded($ext)) {
        die("Required PHP extension not loaded: {$ext}");
    }
}

// Data directory (relative to the script location)
define('DATA_DIR', __DIR__ . '/data');
define('ACCOUNTS_FILE', DATA_DIR . '/accounts.json');
define('PNL_FILE', DATA_DIR . '/pnl_report.json'); // <-- ADD THIS LINE


// Ensure data directory exists
if (!is_dir(DATA_DIR)) {
    if (!mkdir(DATA_DIR, 0775, true)) {
        // Log or display a critical error - cannot proceed without data dir
        logError("CRITICAL: Failed to create data directory: " . DATA_DIR);
        die("Error: Could not create data directory. Please create it manually and ensure it's writable by the web server.");
    }
} elseif (!is_writable(DATA_DIR)) {
    logError("CRITICAL: Data directory is not writable: " . DATA_DIR);
    die("Error: The data directory is not writable. Please check permissions.");
}

// Enable error reporting for debugging during development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Load Composer Autoloader
require_once 'vendor/autoload.php';
if (!class_exists('QuickBooksOnline\API\DataService\DataService')) {
     die("QuickBooks SDK not found. Please run 'composer install' or check autoload path.");
}

// Start session if not already started
if (!session_id()) {
    session_start();
}

?>