<?php
require_once 'config.php'; // Defines PNL_FILE

header('Content-Type: application/json');

if (!file_exists(PNL_FILE)) {
    http_response_code(404);
    echo json_encode(['error' => 'P&L report file not found. Please refresh P&L data first.']);
    exit;
}

$jsonData = file_get_contents(PNL_FILE);

if ($jsonData === false) {
    http_response_code(500);
    logError("Failed to read P&L report file", PNL_FILE);
    echo json_encode(['error' => 'Failed to read P&L report file.']);
    exit;
}

// Optional validation
$data = json_decode($jsonData);
if (json_last_error() !== JSON_ERROR_NONE) {
     http_response_code(500);
     logError("Failed to decode P&L JSON data", ['file' => PNL_FILE, 'error' => json_last_error_msg()]);
     echo json_encode(['error' => 'P&L report file contains invalid JSON.']);
     exit;
}

// Output raw JSON
echo $jsonData;
exit;
?>