<?php
/**
 * Device Selection Page - MAC Address Configuration
 */

// Get available MACs for precontrolled mode
$availableMACs = [];
if ($config['features']['mac_modes']['precontrolled']) {
    $availableMACs = getCompanyMACs($config['comp_group']);
}
?>

<div class="device-selector">
    <h2 style="text-align: center; margin-bottom: 30px;">Select Device</h2>
    
    <?php if ($config['features']['mac_modes']['entered']): ?>
    <!-- MAC Entered Mode -->
    <div style="margin-bottom: 40px;">
        <h3 style="font-size: 16px; margin-bottom: 16px; opacity: 0.9;">Enter MAC Address</h3>
        <div class="form-group">
            <input 
                type="text" 
                id="mac-input" 
                class="form-input" 
                placeholder="AA:BB:CC:DD:EE:FF"
                pattern="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"
                style="text-transform: uppercase; font-family: 'Courier New', monospace;"
            >
        </div>
        <button type="button" id="mac-submit" class="btn btn-secondary">
            Use This Device
        </button>
    </div>
    <?php endif; ?>
    
    <?php if ($config['features']['mac_modes']['precontrolled'] && $config['features']['mac_modes']['entered']): ?>
    <div style="text-align: center; margin: 30px 0;">
        <span style="opacity: 0.5;">— OR —</span>
    </div>
    <?php endif; ?>
    
    <?php if ($config['features']['mac_modes']['precontrolled']): ?>
    <!-- MAC Precontrolled Mode -->
    <div>
        <h3 style="font-size: 16px; margin-bottom: 16px; opacity: 0.9;">Select from Available Devices</h3>
        <div class="form-group">
            <select id="mac-select" class="form-input">
                <option value="">Choose a device...</option>
                <?php foreach ($availableMACs as $mac): ?>
                <option value="<?php echo htmlspecialchars($mac['MAC']); ?>">
                    <?php echo htmlspecialchars($mac['SN']); ?> - <?php echo htmlspecialchars($mac['MAC']); ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <?php endif; ?>
</div>