<?php
/**
 * GLANCE Mobile - Database Configuration
 * TODO: Update all database credentials below before deployment
 */

require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

// Database Configuration
define('DB_HOST', $host_gscroll); // TODO: Update with your database host
define('DB_NAME', $database_gscroll); // TODO: Update with your database name  
define('DB_USER', $username_gscroll); // TODO: Update with your database username
define('DB_PASS', $password_gscroll); // TODO: Update with your database password

// Application Configuration
define('BASE_URL', SERVER_URL);
define('CUSTOM_PATH', __DIR__ . '/../');
define('UPLOAD_BASE', __DIR__ . '/../../uploads/');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 1); // Enable for HTTPS
ini_set('session.cookie_samesite', 'Strict');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_name('GLANCE_SESSION');
    session_start();
}

/**
 * Get database connection
 * @return PDO Database connection object
 */
function getDB() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
                ]
            );
        } catch (PDOException $e) {
            // TODO: In production, log error and show generic message
            error_log("Database connection failed: " . $e->getMessage());
            die("Database connection failed. Please contact support.");
        }
    }
    
    return $pdo;
}

/**
 * Get company configuration from JSON file
 * @param string $companyName Company identifier
 * @return array|null Configuration array or null if not found
 */
function getCompanyConfig($companyName) {
    $configFile = CUSTOM_PATH . $companyName . '/config.json';
    if (!file_exists($configFile)) {
        return null;
    }
    return json_decode(file_get_contents($configFile), true);
}

/**
 * Sanitize user input
 * @param string $input Raw input
 * @return string Sanitized input
 */
function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

/**
 * Check if MAC address exists in serial mapping
 * @param string $mac MAC address
 * @param string $compGroup Company group
 * @return bool
 */
function validateMAC($mac, $compGroup) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT 1 FROM serial_mapping WHERE MAC = ? AND comp_group = ? LIMIT 1");
        $stmt->execute([$mac, $compGroup]);
        return (bool) $stmt->fetch();
    } catch (PDOException $e) {
        error_log("MAC validation error: " . $e->getMessage());
        return false;
    }
}

/**
 * Get available MAC addresses for a company
 * @param string $compGroup Company group
 * @return array List of MAC addresses
 */
function getCompanyMACs($compGroup) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT MAC, SN FROM serial_mapping WHERE comp_group = ? ORDER BY SN");
        $stmt->execute([$compGroup]);
        return $stmt->fetchAll();
    } catch (PDOException $e) {
        error_log("Failed to get company MACs: " . $e->getMessage());
        return [];
    }
}