<?php
/**
 * Content Library Page - Selection Grid and Content Management
 */

// Get device selections
$deviceData = getDeviceSelections($currentMAC);
$currentSelections = $deviceData['Selections'] ?? [];

// Get content library
$contentLibrary = getContentLibrary($config['comp_group']);

// Check upload limit
$uploadStatus = checkUploadLimit($config['comp_group']);
?>

<div class="content-library">
    <h2 style="text-align: center; margin-bottom: 20px;">All Selections</h2>
    
    <!-- Selection Grid -->
    <div class="selection-grid">
        <?php foreach ($contentLibrary as $item): ?>
        <div class="selection-item <?php echo in_array($item['id'], $currentSelections) ? 'selected' : ''; ?>" 
             data-content-id="<?php echo $item['id']; ?>">
            
            <?php if ($item['content_type'] === 'image' && $item['content_path']): ?>
                <img src="<?php echo $config['paths']['uploads'] . basename($item['content_path']); ?>" 
                     alt="<?php echo htmlspecialchars($item['content_name']); ?>">
            <?php elseif ($item['content_type'] === 'text'): ?>
                <div style="background: #000; color: <?php echo $item['content_data']['color'] ?? '#FFF'; ?>; 
                          padding: 8px; font-size: 12px; word-break: break-word; 
                          max-height: 60px; overflow: hidden;">
                    <?php echo htmlspecialchars($item['content_data']['text'] ?? ''); ?>
                </div>
            <?php endif; ?>
            
            <div class="selection-item-name">
                <?php echo htmlspecialchars($item['content_name']); ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    
    <!-- Back Button -->
    <a href="?page=home" class="btn btn-secondary" style="margin-top: 20px;">
        Back to Device
    </a>
    
    <!-- Add Button -->
    <div class="add-button" title="Add Content"></div>
    
    <!-- Add Content Modal -->
    <div id="add-content-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Add Content</h3>
                <button class="modal-close" onclick="closeModal('add-content-modal')">×</button>
            </div>
            
            <div style="display: flex; flex-direction: column; gap: 16px;">
                <?php if ($config['features']['content_types']['image']['enabled']): ?>
                <button class="btn" onclick="showModal('upload-modal'); closeModal('add-content-modal');">
                    Add Image
                </button>
                <?php endif; ?>
                
                <?php if ($config['features']['content_types']['text']['enabled']): ?>
                <button class="btn btn-secondary" onclick="showModal('text-modal'); closeModal('add-content-modal');">
                    Add Text
                </button>
                <?php endif; ?>
            </div>
            
            <?php if (!$uploadStatus['allowed']): ?>
            <div class="status-message status-warning" style="margin-top: 16px;">
                Daily upload limit reached (<?php echo $uploadStatus['count']; ?>/<?php echo $uploadStatus['limit']; ?>)
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Upload Image Modal -->
    <div id="upload-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Upload Image</h3>
                <button class="modal-close" onclick="closeModal('upload-modal')">×</button>
            </div>
            
            <div class="upload-area">
                <div class="upload-icon">📷</div>
                <p>Drag & drop image here or click to browse</p>
                <p style="font-size: 12px; opacity: 0.7; margin-top: 8px;">
                    Max size: <?php echo $config['features']['content_types']['image']['max_size_kb']; ?>KB<br>
                    Dimensions: <?php echo $config['features']['content_types']['image']['dimensions']['width']; ?>x<?php echo $config['features']['content_types']['image']['dimensions']['height']; ?>px
                </p>
            </div>
            
            <input type="file" id="image-upload" accept="image/*" style="display: none;">
            <button id="upload-btn" class="btn btn-secondary" style="margin-bottom: 16px;">
                Choose Image
            </button>
            
            <div class="form-group">
                <label for="image-name" class="form-label">Image Name</label>
                <input type="text" id="image-name" class="form-input" placeholder="Enter image name">
            </div>
            
            <img id="image-preview" style="display: none; max-width: 100%; margin-bottom: 16px;">
            
            <button id="save-image-btn" class="btn" onclick="handleFile(document.getElementById('image-upload').files[0])">
                Save Image
            </button>
        </div>
    </div>
    
    <!-- Add Text Modal -->
    <div id="text-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Add Text</h3>
                <button class="modal-close" onclick="closeModal('text-modal')">×</button>
            </div>
            
            <div class="form-group">
                <label for="text-content" class="form-label">Text Content</label>
                <textarea 
                    id="text-content" 
                    class="form-input" 
                    rows="3" 
                    maxlength="<?php echo $config['features']['content_types']['text']['max_length']; ?>"
                    placeholder="Enter your text (max <?php echo $config['features']['content_types']['text']['max_length']; ?> characters)"
                    style="resize: vertical; padding: 12px;"
                ></textarea>
                <div style="text-align: right; font-size: 12px; opacity: 0.7; margin-top: 4px;">
                    <span id="char-count">0</span>/<?php echo $config['features']['content_types']['text']['max_length']; ?>
                </div>
            </div>
            
            <div class="form-group">
                <label for="text-color" class="form-label">Text Color</label>
                <div class="color-picker-wrapper">
                    <div class="color-preview" id="color-preview" 
                         style="background-color: <?php echo $config['features']['content_types']['text']['default_color']; ?>;"></div>
                    <input 
                        type="color" 
                        id="text-color" 
                        class="form-input color-input" 
                        value="<?php echo $config['features']['content_types']['text']['default_color']; ?>"
                        style="height: 48px; padding: 4px;"
                    >
                </div>
            </div>
            
            <button id="save-text-btn" class="btn" onclick="handleAddText()">
                Save Text
            </button>
        </div>
    </div>
</div>

<script>
// Initialize text character counter
document.getElementById('text-content')?.addEventListener('input', function() {
    document.getElementById('char-count').textContent = this.value.length;
});

// Initialize color picker preview
document.getElementById('text-color')?.addEventListener('input', function() {
    document.getElementById('color-preview').style.backgroundColor = this.value;
});

// Set current selections
AppState.selections = <?php echo json_encode(array_values($currentSelections)); ?>;

// Initialize content library reload function
window.loadContentLibrary = function() {
    window.location.reload();
};
</script>