<?php
/**
 * Clear Selections API Endpoint
 */

require_once '../../lib/database.php';
require_once '../../lib/functions.php';

header('Content-Type: application/json');

// Check authentication
if (!isAuthenticated('jackmorton')) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

// Handle POST requests only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['mac'])) {
    echo json_encode(['success' => false, 'error' => 'MAC address required']);
    exit;
}

$mac = strtoupper(sanitizeInput($input['mac']));
$clearAll = isset($input['clear_all']) ? (bool)$input['clear_all'] : false;

// Validate MAC format
if (!preg_match('/^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$/i', $mac)) {
    echo json_encode(['success' => false, 'error' => 'Invalid MAC address format']);
    exit;
}

// Load config
$config = getCompanyConfig('jackmorton');

// Clear selections
if (clearSelections($mac, $config['comp_group'], $clearAll)) {
    echo json_encode([
        'success' => true,
        'message' => $clearAll ? 'All selections cleared' : 'Company selections cleared'
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to clear selections']);
}