<?php
/**
 * Login Page - Company Key Authentication
 */
?>

<div class="login-container">
    <!-- Company Logo Section -->
    <div class="logo-section" style="margin-bottom: 50px;">
        <?php if (isset($config['theme']['company_logo']) && file_exists(__DIR__ . '/../' . $config['theme']['company_logo'])): ?>
            <img src="<?php echo $config['theme']['company_logo']; ?>" 
                 alt="<?php echo htmlspecialchars($config['company_name']); ?> Logo"
                 style="width: 240px; height: auto; display: block; margin: 0 auto;">
        <?php else: ?>
            <!-- Fallback if no logo -->
            <div style="background: <?php echo $config['theme']['primary_color']; ?>; 
                 width: 100px; height: 100px; border-radius: 50%; 
                 display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                <div style="width: 80px; height: 80px; background: white; border-radius: 50%; 
                     display: flex; align-items: center; justify-content: center; font-weight: bold; 
                     color: <?php echo $config['theme']['primary_color']; ?>; font-size: 24px;">
                    <?php echo substr($config['company_name'], 0, 2); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <form id="login-form" class="login-form" method="post" style="max-width: 320px; margin: 0 auto;">
        <div class="form-group" style="margin-bottom: 24px;">
            <label for="company-key" class="form-label" style="font-size: 14px; margin-bottom: 12px; opacity: 0.8;">Company Key</label>
            <input 
                type="text" 
                id="company-key" 
                name="company_key" 
                class="form-input" 
                placeholder="Enter company key"
                required
                autocomplete="off"
                autofocus
                style="font-size: 16px; letter-spacing: 0.5px;"
            >
        </div>
        
        <button type="submit" class="btn" style="margin-top: 24px; font-size: 16px; font-weight: 600;">
            Access Application
        </button>
    </form>
</div>