<?php
// dashboard_api_fixed.php
require_once '../../config.php';

// connect
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) {
    header('Content-Type: application/json');
    die(json_encode(['error' => 'Connection failed: ' . mysqli_connect_error()]));
}

// helper: binary IP → dotted quad
function binaryToIp($binaryIp) {
    if (strlen($binaryIp) === 4) {
        $u = unpack('N', $binaryIp);
        return long2ip($u[1]);
    }
    return null;
}


// avg online time
function calculateAverageOnlineTime($con) {
    $sql = "
      SELECT AVG(heartbeat * 10) AS avg_minutes
      FROM (
        SELECT mac_address, AVG(heartbeat) AS heartbeat
        FROM glance_led_v2_tracking
        WHERE heartbeat > 1
        GROUP BY mac_address
      ) sub
    ";
    $res = mysqli_query($con, $sql);
    if (!$res) return 0;
    $row = mysqli_fetch_assoc($res);
    return round($row['avg_minutes'] ?? 0);
}

// grab latest session per MAC + map SN
$sql = "
  SELECT
    t1.mac_address,
    t1.ip_address,
    t1.region_name,
    t1.city,
    t1.isp,
    t1.zip,
    t1.lat,
    t1.lon,
    t1.timezone,
    t1.session_count,
    t1.last_ping_time,
    sm.SN
  FROM glance_led_v2_tracking t1
  JOIN (
    SELECT mac_address, MAX(session_count) AS max_session
    FROM glance_led_v2_tracking
    GROUP BY mac_address
  ) t2 ON t1.mac_address = t2.mac_address
       AND t1.session_count = t2.max_session
  LEFT JOIN serial_mapping sm
    ON t1.mac_address = sm.MAC
  GROUP BY t1.mac_address
  ORDER BY t1.last_ping_time DESC
";
$result = mysqli_query($con, $sql);

$devices = [];
$onlineUsers = 0;
$stateDistribution = [];

if ($result) {
    // build devices array using stored geolocation data
    while ($r = mysqli_fetch_assoc($result)) {
        $ip = binaryToIp($r['ip_address']);

        // determine online/offline
        $q = "SELECT TIMESTAMPDIFF(MINUTE,'{$r['last_ping_time']}',NOW()) AS m";
        $t = mysqli_fetch_assoc(mysqli_query($con, $q))['m'];
        $isOnline = ($t <= 10);
        if ($isOnline) {
            $onlineUsers++;
        }

        // calculate current session online time
        $mac      = mysqli_real_escape_string($con, $r['mac_address']);
        $session  = (int)$r['session_count'];
        $hbSql    = "
            SELECT SUM(heartbeat) AS total_heartbeats
            FROM glance_led_v2_tracking
            WHERE mac_address = '{$mac}'
              AND session_count = {$session}
        ";
        $hbRes    = mysqli_query($con, $hbSql);
        $hbRow    = mysqli_fetch_assoc($hbRes);
        $heartbeats = (int)($hbRow['total_heartbeats'] ?? 0);
        $minutes    = $heartbeats * 10;
        if ($minutes >= 60) {
            $hours = floor($minutes / 60);
            $mins  = $minutes % 60;
            $onlineTime = $hours . ' HR' . ($mins > 0 ? ' ' . $mins . ' min' : '');
        } else {
            $onlineTime = $minutes . ' min';
        }

        // Use stored geo info from database
        $state = $r['region_name'] ?? 'Unknown';
        $city  = $r['city'] ?? '';
        $lat   = $r['lat'] ?? null;
        $lon   = $r['lon'] ?? null;

        // Handle local network IPs
        if ($ip && !filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE|FILTER_FLAG_NO_RES_RANGE)) {
            $state = 'Local Network';
        }

        // Always increment state distribution
        $stateDistribution[$state] = ($stateDistribution[$state] ?? 0) + 1;

        $devices[] = [
            'mac_address'         => $r['mac_address'],
            'sn'                  => $r['SN'] ?? null,
            'ip_address'          => $ip ?: 'Invalid IP',
            'state'               => $state,
            'city'                => $city,
            'lat'                 => $lat,
            'lon'                 => $lon,
            'session_count'       => $session,
            'last_seen'           => date('M j, g:i A', strtotime($r['last_ping_time'])),
            'isOnline'            => $isOnline,
            'current_online_time' => $onlineTime
        ];
    }
}

$avgOnlineMinutes = calculateAverageOnlineTime($con);
mysqli_close($con);


// output JSON
header('Content-Type: application/json');
echo json_encode([
    'onlineUsers'          => $onlineUsers,
    'totalDevices'         => count($devices),
    'avgOnlineMinutes'     => $avgOnlineMinutes,
    'stateDistribution'    => $stateDistribution,
    'devices'              => $devices
]);
?>