<!-- No-Code Interface Template -->
<!-- This will replace the content in templates/no-code.php -->
<div class="app-container">
    <!-- Left Panel - Settings (Keep unchanged) -->
    <div class="left-panel">
        <!-- Mode Selection -->
        <div class="panel-section">
            <h3 class="section-title">EDIT MODE</h3>
            <div class="btn-group btn-group-vertical">
                <a href="?mode=low-code&size=<?php echo $canvasWidth . 'x' . $canvasHeight; ?>" class="btn <?php echo $mode === 'low-code' ? 'active' : ''; ?>">Low Code</a>
                <a href="?mode=no-code&size=<?php echo $canvasWidth . 'x' . $canvasHeight; ?>" class="btn <?php echo $mode === 'no-code' ? 'active' : ''; ?>">No Code</a>
            </div>
        </div>
        
        <!-- Canvas Size Selector -->
        <div class="panel-section">
            <h3 class="section-title">CANVAS SIZE</h3>
            <div class="btn-group btn-group-vertical">
                <a href="?size=64x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 64 ? 'active' : ''; ?>">64×32</a>
                <a href="?size=128x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 128 ? 'active' : ''; ?>">128×32</a>
                <a href="?size=192x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 192 ? 'active' : ''; ?>">192×32</a>
            </div>
        </div>
        
        <!-- Publishing Options -->
        <div class="panel-section">
            <h3 class="section-title">PUBLISH</h3>
            <div class="form-group">
                <label for="app-title">Application Title</label>
                <input type="text" id="app-title" name="app-title" placeholder="My LED App" required>
            </div>
            
            <div class="form-group">
                <label for="execution-time">Execution Interval</label>
                <select id="execution-time" name="execution-time">
                    <option value="5">5 minutes</option>
                    <option value="15">15 minutes</option>
                    <option value="30">30 minutes</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="visibility">Visibility</label>
                <select id="visibility" name="visibility">
                    <option value="public">Public</option>
                    <option value="private">Private</option>
                </select>
            </div>
            
            <button id="submit-btn" class="btn btn-primary btn-full">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 6px;">
                    <path d="M5 12H19M19 12L13 6M19 12L13 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                Publish Application
            </button>
        </div>
    </div>
    
    <!-- Main Content Area -->
    <div class="main-content">
        <!-- Workflow Editor -->
        <div class="editor-container">
            <div class="preview-header">
                <h3 class="preview-title">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#10B981" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8 3H5C3.89543 3 3 3.89543 3 5V8M8 3H16M8 3V6M16 3H19C20.1046 3 21 3.89543 21 5V8M16 3V6M21 8V16M21 8H18M21 16V19C21 20.1046 20.1046 21 19 21H16M21 16H18M16 21H8M16 21V18M8 21H5C3.89543 21 3 20.1046 3 19V16M8 21V18M3 16V8M3 16H6M3 8H6M6 8V16M6 16H18M6 8H18M18 8V16" stroke="#10B981" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span> Workflow Editor</span>
                </h3>
            </div>
            <div class="workflow-area">
                <!-- Blocks will be added here -->
                <div class="empty-workflow-message">
                    <p>Drag blocks from the library to start building your application</p>
                </div>
            </div>
        </div>
        
        <!-- Preview Section -->
        <div class="preview-section">
            <div class="preview-header">
                <h3 class="preview-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#10B981" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <span> Preview</span>
                </h3>
                <!-- Preview controls -->
                <div class="preview-controls">
                    <label class="checkbox-label">
                        <input type="checkbox" id="show-grid" checked>
                        <span>Grid</span>
                    </label>
                    <span class="preview-dimensions"><?php echo $canvasWidth; ?> × <?php echo $canvasHeight; ?></span>
                    <button id="preview-btn" class="btn btn-primary">
                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 3L19 12L5 21V3Z" fill="currentColor"/>
                        </svg>
                        Preview
                    </button>
                </div>
            </div>
            <div class="canvas-wrapper">
                <canvas id="preview-canvas" width="<?php echo $canvasWidth; ?>" height="<?php echo $canvasHeight; ?>"></canvas>
                <!-- Grid overlay and zoom/pan controls will be added by JavaScript -->
            </div>
        </div>        
    </div>
    
    <!-- Right Panel - Block Library and Properties -->
    <div class="right-panel">
        <!-- Block Library Section -->
        <div class="panel-section block-library-section">
            <h3 class="section-title">BLOCK LIBRARY</h3>
            <div class="blocks-container">
                <div class="block-item" 
                     draggable="true" 
                     data-block-type="drawText"
                     data-tooltip="Draw text at specific coordinates">
                    <div class="block-icon">T</div>
                    <div class="block-label">Text</div>
                </div>
                
                <div class="block-item" 
                     draggable="true" 
                     data-block-type="setPixel"
                     data-tooltip="Set a single pixel color">
                    <div class="block-icon">•</div>
                    <div class="block-label">Pixel</div>
                </div>
                
                <div class="block-item" 
                     draggable="true" 
                     data-block-type="getData"
                     data-tooltip="Fetch data from an API endpoint">
                    <div class="block-icon">{}</div>
                    <div class="block-label">Data</div>
                </div>
            </div>
        </div>
        
        <!-- Resize handle -->
        <div class="right-panel-resize-handle"></div>
        
        <!-- Block Properties Section -->
        <div class="panel-section properties-section">
            <h3 class="section-title">PROPERTIES</h3>
            <div class="properties-container">
                <!-- Properties will be loaded here dynamically based on selected block -->
                <div class="no-block-selected-message">
                    <p>Select a block to edit its properties</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Block Templates (hidden, used for cloning) -->
<template id="text-block-template">
    <div class="workflow-block" data-block-type="drawText">
        <div class="block-drag-handle">⋮⋮</div>
        <div class="block-content">
            <div class="block-icon">T</div>
            <div class="block-summary">
                <div class="block-title">Text</div>
                <div class="block-description">Text: "<span class="text-value">GLANCE</span>" at (<span class="x-value">5</span>,<span class="y-value">10</span>)</div>
            </div>
        </div>
        <div class="block-actions">
            <button class="block-action-btn block-edit" title="Edit">✎</button>
            <button class="block-action-btn block-delete" title="Delete">×</button>
        </div>
    </div>
</template>

<template id="pixel-block-template">
    <div class="workflow-block" data-block-type="setPixel">
        <div class="block-drag-handle">⋮⋮</div>
        <div class="block-content">
            <div class="block-icon">•</div>
            <div class="block-summary">
                <div class="block-title">Pixel</div>
                <div class="block-description">Pixel at (<span class="x-value">10</span>,<span class="y-value">10</span>)</div>
            </div>
        </div>
        <div class="block-actions">
            <button class="block-action-btn block-edit" title="Edit">✎</button>
            <button class="block-action-btn block-delete" title="Delete">×</button>
        </div>
    </div>
</template>

<template id="data-block-template">
    <div class="workflow-block" data-block-type="getData">
        <div class="block-drag-handle">⋮⋮</div>
        <div class="block-content">
            <div class="block-icon">{}</div>
            <div class="block-summary">
                <div class="block-title">Data</div>
                <div class="block-description">API: <span class="url-value">api.example.com</span></div>
            </div>
        </div>
        <div class="block-actions">
            <button class="block-action-btn block-edit" title="Edit">✎</button>
            <button class="block-action-btn block-delete" title="Delete">×</button>
        </div>
    </div>
</template>

<!-- Property Panel Templates -->
<template id="text-properties-template">
    <div class="block-properties" data-block-type="drawText">
        <h4>Text Block Properties</h4>
        <div class="form-group">
            <label for="prop-text">Text</label>
            <input type="text" id="prop-text" name="text" value="GLANCE">
        </div>
        <div class="form-group">
            <label for="prop-x">X Position</label>
            <input type="number" id="prop-x" name="x" value="5" min="0" max="<?php echo $canvasWidth-1; ?>">
        </div>
        <div class="form-group">
            <label for="prop-y">Y Position</label>
            <input type="number" id="prop-y" name="y" value="10" min="0" max="<?php echo $canvasHeight-1; ?>">
        </div>
        <div class="form-group">
            <label for="prop-color">Color</label>
            <div class="color-picker-container">
                <input type="text" id="prop-color" name="color" value="#00FF00">
                <input type="color" id="prop-color-picker" value="#00FF00">
            </div>
        </div>
        <div class="form-group">
            <label for="prop-font">Font</label>
            <select id="prop-font" name="font">
                <option value="bitmap_5x7">5x7 (Default)</option>
                <option value="bitmap_3x4">3x4 (Tiny)</option>
                <option value="bitmap_6x8">6x8</option>
                <option value="bitmap_7x16">7x16 (Large)</option>
            </select>
        </div>
        <div class="form-group">
            <label for="prop-alignment">Alignment</label>
            <select id="prop-alignment" name="alignment">
                <option value="left">Left</option>
                <option value="center">Center</option>
                <option value="right">Right</option>
            </select>
        </div>
    </div>
</template>

<template id="pixel-properties-template">
    <div class="block-properties" data-block-type="setPixel">
        <h4>Pixel Block Properties</h4>
        <div class="form-group">
            <label for="prop-x">X Position</label>
            <input type="number" id="prop-x" name="x" value="10" min="0" max="<?php echo $canvasWidth-1; ?>">
        </div>
        <div class="form-group">
            <label for="prop-y">Y Position</label>
            <input type="number" id="prop-y" name="y" value="10" min="0" max="<?php echo $canvasHeight-1; ?>">
        </div>
        <div class="form-group">
            <label for="prop-color">Color</label>
            <div class="color-picker-container">
                <input type="text" id="prop-color" name="color" value="#FFFFFF">
                <input type="color" id="prop-color-picker" value="#FFFFFF">
            </div>
        </div>
    </div>
</template>

<template id="data-properties-template">
    <div class="block-properties" data-block-type="getData">
        <h4>Data Block Properties</h4>
        <div class="form-group">
            <label for="prop-url">API URL</label>
            <input type="text" id="prop-url" name="url" value="https://api.example.com/data">
        </div>
        <div class="form-group">
            <label for="prop-apikey">API Key (Optional)</label>
            <input type="text" id="prop-apikey" name="apiKey" placeholder="Enter API key">
        </div>
        <div class="form-group">
            <label for="prop-variable">Save Result As</label>
            <input type="text" id="prop-variable" name="variable" value="data">
        </div>
    </div>
</template>

<!-- Make sure to add the CSS first -->
<style>

</style>

<!-- Integration script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if we're in no-code mode
    if (document.body.getAttribute('data-mode') !== 'no-code') return;
    
    // Make blocks draggable
    document.querySelectorAll('.block').forEach(block => {
        block.setAttribute('draggable', true);
    });
    
    // Create workflow container and area if they don't exist
    const blocksCanvas = document.querySelector('.blocks-canvas');
    if (blocksCanvas && !document.querySelector('.workflow-container')) {
        const workflowContainer = document.createElement('div');
        workflowContainer.className = 'workflow-container';
        
        // Create workflow area
        const workflowArea = document.createElement('div');
        workflowArea.className = 'workflow-area';
        workflowArea.innerHTML = `
            <div class="empty-workflow-message">
                <p>Drag blocks from the library to start building your application</p>
            </div>
        `;
        
        // Create properties container
        const propertiesContainer = document.createElement('div');
        propertiesContainer.className = 'properties-container';
        propertiesContainer.innerHTML = `
            <div class="no-block-selected-message">
                <p>Select a block to edit its properties</p>
            </div>
        `;
        
        // Add to workflow container
        workflowContainer.appendChild(workflowArea);
        workflowContainer.appendChild(propertiesContainer);
        
        // Add to blocks canvas
        blocksCanvas.appendChild(workflowContainer);
    }
});
</script>