<div class="app-container">
    <!-- Left Panel - Settings -->
    <div class="left-panel">
        <!-- Mode Selection -->
        <div class="panel-section">
            <h3 class="section-title">EDIT MODE</h3>
            <div class="btn-group btn-group-vertical">
                <a href="?mode=low-code&size=<?php echo $canvasWidth . 'x' . $canvasHeight; ?>" class="btn <?php echo $mode === 'low-code' ? 'active' : ''; ?>">Low Code</a>
                <a href="?mode=no-code&size=<?php echo $canvasWidth . 'x' . $canvasHeight; ?>" class="btn <?php echo $mode === 'no-code' ? 'active' : ''; ?>">No Code</a>
            </div>
        </div>
        
        <!-- Canvas Size Selector -->
        <div class="panel-section">
            <h3 class="section-title">CANVAS SIZE</h3>
            <div class="btn-group btn-group-vertical">
                <a href="?size=64x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 64 ? 'active' : ''; ?>">64×32</a>
                <a href="?size=128x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 128 ? 'active' : ''; ?>">128×32</a>
                <a href="?size=192x32&mode=<?php echo $mode; ?>" class="btn <?php echo $canvasWidth === 192 ? 'active' : ''; ?>">192×32</a>
            </div>
        </div>
        
        <!-- Publishing Options -->
        <div class="panel-section">
            <h3 class="section-title">PUBLISH</h3>
            <div class="form-group">
                <label for="app-title">Application Title</label>
                <input type="text" id="app-title" name="app-title" placeholder="My LED App" required>
            </div>
            
            <div class="form-group">
                <label for="execution-time">Execution Interval</label>
                <select id="execution-time" name="execution-time">
                    <option value="5">5 minutes</option>
                    <option value="15">15 minutes</option>
                    <option value="30">30 minutes</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="visibility">Visibility</label>
                <select id="visibility" name="visibility">
                    <option value="public">Public</option>
                    <option value="private">Private</option>
                </select>
            </div>
            
            <button id="submit-btn" class="btn btn-primary btn-full">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 6px;">
                    <path d="M5 12H19M19 12L13 6M19 12L13 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                Publish Application
            </button>
        </div>
    </div>
    
    <!-- Main Content Area -->
    <div class="main-content">
        <!-- Code Editor -->
        <div class="editor-container">
            <div class="preview-header">
                <h3 class="preview-title">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8 3H5C3.89543 3 3 3.89543 3 5V8M8 3H16M8 3V6M16 3H19C20.1046 3 21 3.89543 21 5V8M16 3V6M21 8V16M21 8H18M21 16V19C21 20.1046 20.1046 21 19 21H16M21 16H18M16 21H8M16 21V18M8 21H5C3.89543 21 3 20.1046 3 19V16M8 21V18M3 16V8M3 16H6M3 8H6M6 8V16M6 16H18M6 8H18M18 8V16" stroke="#10B981" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span> Code Editor</span>
                </h3>
            </div>
            
            <div class="code-editor-wrapper">
                <textarea id="php-code" placeholder=""></textarea>
                <div id="code-errors" class="code-errors" style="display: none;"></div>
            </div>
            
            <!-- Resize handle will be added by JavaScript -->
        </div>
        
        <!-- Preview Section -->
        <div class="preview-section">
            <div class="preview-header">
                <h3 class="preview-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#10B981" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <span> Preview</span>
                </h3>
                <!-- Preview controls -->
                <div class="preview-controls">
                    <label class="checkbox-label">
                        <input type="checkbox" id="show-grid" checked>
                        <span>Grid</span>
                    </label>
                    <span class="preview-dimensions"><?php echo $canvasWidth; ?> × <?php echo $canvasHeight; ?></span>
                    <button id="preview-btn" class="btn btn-primary">
                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 3L19 12L5 21V3Z" fill="currentColor"/>
                        </svg>
                        Preview
                    </button>
                </div>
            </div>
            <div class="canvas-wrapper">
                <canvas id="preview-canvas" width="<?php echo $canvasWidth; ?>" height="<?php echo $canvasHeight; ?>"></canvas>
                <!-- Grid overlay and zoom/pan controls will be added by JavaScript -->
            </div>
        </div>        
    </div>
    
    <!-- Right Panel - Help -->
    <div class="right-panel">
        <div class="panel-section">
            <h3 class="section-title">HELP</h3>
            <div class="help-accordion">
                <div class="help-section">
                    <div class="help-header">
                        <span>drawText()</span>
                        <span class="arrow">▼</span>
                    </div>
                    <div class="help-content">
                        <p>Draws bitmap text on the LED panel.</p>
                        <div class="code-with-copy">
                            <div class="code-block">
                                <code>drawText(5, 10, 'GLANCE', '#00FF00', 'bitmap_5x7', 'left');</code>
                            </div>
                            <button class="copy-btn" data-code="drawText(5, 10, 'GLANCE', '#00FF00', 'bitmap_5x7', 'left');">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 3H5C3.89543 3 3 3.89543 3 5V19C3 20.1046 3.89543 21 5 21H19C20.1046 21 21 20.1046 21 19V16M21 9V3C21 1.89543 20.1046 1 19 1H13C11.8954 1 11 1.89543 11 3V9C11 10.1046 11.8954 11 13 11H19C20.1046 11 21 10.1046 21 9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                Copy
                            </button>
                        </div>
                        <p><strong>Parameters:</strong></p>
                        <p>x: X coordinate (0-<?php echo $canvasWidth-1; ?>)<br>
                        y: Y coordinate (0-<?php echo $canvasHeight-1; ?>)<br>
                        text: Display Text<br>
                        color: Hex code (e.g. "#10B981")<br>
                        fontName: Font name (optional, default: 'bitmap_5x7')<br>
                        justification: 'left', 'center', or 'right' (optional, default: 'left')</p>
                        
                        <p><strong>Available Fonts:</strong></p>
                        <ul>
                            <?php 
                            $fonts = getAvailableBitmapFonts();
                            foreach ($fonts as $font): 
                                $displayFont = str_replace('bitmap_', '', $font);
                            ?>
                                <li><?php echo $displayFont; ?></li>
                            <?php endforeach; ?>
                            <?php if (empty($fonts)): ?>
                                <li>5x7 (default)</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                
                <div class="help-section">
                    <div class="help-header">
                        <span>getData()</span>
                        <span class="arrow">▼</span>
                    </div>
                    <div class="help-content">
                        <p>Fetches data from an API endpoint.</p>
                        <div class="code-with-copy">
                            <div class="code-block">
                                <code>getData(url, apiKey);</code>
                            </div>
                            <button class="copy-btn" data-code="$data = getData('https://api.example.com/data', 'your-api-key');">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 3H5C3.89543 3 3 3.89543 3 5V19C3 20.1046 3.89543 21 5 21H19C20.1046 21 21 20.1046 21 19V16M21 9V3C21 1.89543 20.1046 1 19 1H13C11.8954 1 11 1.89543 11 3V9C11 10.1046 11.8954 11 13 11H19C20.1046 11 21 10.1046 21 9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                Copy
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="help-section">
                    <div class="help-header">
                        <span>setPixel()</span>
                        <span class="arrow">▼</span>
                    </div>
                    <div class="help-content">
                        <p>Sets a single pixel on the LED panel.</p>
                        <div class="code-with-copy">
                            <div class="code-block">
                                <code>setPixel(x, y, color);</code>
                            </div>
                            <button class="copy-btn" data-code="setPixel(10, 10, '#FFFFFF');">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 3H5C3.89543 3 3 3.89543 3 5V19C3 20.1046 3.89543 21 5 21H19C20.1046 21 21 20.1046 21 19V16M21 9V3C21 1.89543 20.1046 1 19 1H13C11.8954 1 11 1.89543 11 3V9C11 10.1046 11.8954 11 13 11H19C20.1046 11 21 10.1046 21 9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                Copy
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="help-section">
                    <div class="help-header">
                        <span>Canvas Navigation</span>
                        <span class="arrow">▼</span>
                    </div>
                    <div class="help-content">
                        <p>You can interact with the preview canvas in several ways:</p>
                        <ul>
                            <li><strong>Zoom:</strong> Use mouse wheel or the + and - buttons</li>
                            <li><strong>Pan:</strong> Click the pan button (✥) and drag the canvas</li>
                            <li><strong>Fit:</strong> Click the reset button (↔) to fit canvas to view</li>
                            <li><strong>Grid:</strong> Toggle the grid checkbox to show/hide the pixel grid</li>
                        </ul>
                        <p>Hover over pixels to see coordinates and color values.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>