<?php
session_start();
define('APP_RUNNING', true);

// Basic configuration
$canvasWidth = 64; // Default
if (isset($_GET['size'])) {
    if ($_GET['size'] == '128x32') {
        $canvasWidth = 128;
    } else if ($_GET['size'] == '192x32') {
        $canvasWidth = 192;
    }
}
$canvasHeight = 32;
$canvasSize = $canvasWidth . 'x' . $canvasHeight;
$mode = isset($_GET['mode']) && $_GET['mode'] == 'no-code' ? 'no-code' : 'low-code';


// Initialize pixel data
$pixelData = array_fill(0, $canvasWidth * $canvasHeight, '#000000');

// Include necessary fileshe
require_once 'lib/security.php';
require_once 'lib/draw.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com;">
    <link rel="icon" href="assets/img/DEVELOPER-favicon2.png" type="image/x-icon">
    <title>LED Panel Developer Platform</title>
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo hash('sha256', session_id()); ?>">
    <!-- Update all CodeMirror components to the same version, like 5.65.3 -->
    <!-- Exact, explicit version loading -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/codemirror.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/theme/monokai.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/mode/clike/clike.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/mode/php/php.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/addon/edit/matchbrackets.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.12/addon/comment/comment.min.js"></script>


</head>
<body data-mode="<?php echo $mode; ?>" data-canvas-size="<?php echo $canvasWidth . 'x' . $canvasHeight; ?>">
    <header>
        <div class="logo">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect x="2" y="4" width="20" height="16" rx="2" stroke="#10B981" stroke-width="2"/>
                <rect x="5" y="7" width="3" height="3" fill="#10B981"/>
                <rect x="5" y="11" width="3" height="3" fill="#10B981"/>
                <rect x="5" y="15" width="3" height="3" fill="#10B981"/>
                <rect x="9" y="7" width="3" height="3" fill="#10B981"/>
                <rect x="9" y="11" width="3" height="3" fill="#10B981"/>
                <rect x="9" y="15" width="3" height="3" fill="#10B981"/>
                <rect x="13" y="7" width="3" height="3" fill="#10B981"/>
                <rect x="13" y="11" width="3" height="3" fill="#10B981"/>
                <rect x="13" y="15" width="3" height="3" fill="#10B981"/>
                <rect x="17" y="7" width="3" height="3" fill="#10B981"/>
                <rect x="17" y="11" width="3" height="3" fill="#10B981"/>
                <rect x="17" y="15" width="3" height="3" fill="#10B981"/>
            </svg>
            <span>GLANCE Developer</span>
        </div>
        
        <div class="user-info">
            <span>User: <?php echo isset($_SESSION['username']) ? $_SESSION['username'] : 'Guest'; ?></span>
            <a href="?help" class="help-icon">?</a>
        </div>
    </header>

    <main>
        <?php if ($mode === 'low-code'): ?>
            <?php include 'templates/low-code.php'; ?>
        <?php else: ?>
            <?php include 'templates/no-code.php'; ?>
        <?php endif; ?>
    </main>

    <script src="./assets/js/fontConverter.js"></script>
    <script src="./assets/js/canvas.js"></script>
    <script src="./assets/js/compiler.js"></script>
    <script src="./assets/js/main.js"></script>
    <script src="./assets/js/no-code.js"></script>
    <script src="./assets/js/simple-divider.js"></script> <!-- Critical For Divider -->
    <script src="./assets/js/workflow-integration.js"></script> <!-- Workflow Formatring -->
    <script src="./assets/js/no-code-init.js"></script><!-- Critical Canvas Rendering -->
    <!-- <script src="./assets/js/auto-preview.js"></script> --> <!-- Auto Preview Works, but we don't need it for now --> 
    <script src="./assets/js/improved-drag-drop.js"></script> <!-- Critical For Drag & Drop Reordering -->
    <script src="./assets/js/block-persistence.js"></script> <!-- Critical For Drag & Drop Reordering -->
    <script src="./assets/js/workflow-to-php.js"></script> <!-- Critical For Drag & Drop Reordering -->
    <script src="./assets/js/api.js"></script>
 
    
    <div id="app-loader" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0, 0, 0, 0.85); z-index: 9999; justify-content: center; align-items: center;">
    <div style="text-align: center; color: white;">
        <div id="g-animation">
            <svg width="60" height="60" viewBox="0 0 100 100" id="g-loader">
                <!-- Pixelated G Shape -->
                <rect class="pixel" x="10" y="10" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="40" y="10" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="70" y="10" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="10" y="40" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="10" y="70" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="40" y="70" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="70" y="70" width="20" height="20" fill="#10B981" />
                <rect class="pixel" x="70" y="40" width="20" height="20" fill="#10B981" />
            </svg>
            <div id="loader-text" style="margin-top: 20px; font-family: 'Inter', sans-serif; font-weight: 500;">Building Preview...</div>
        </div>
    </div>
</div>

<style>
    @keyframes pixelFade {
        0% { fill: #10B981; }
        50% { fill: #FFFFFF; }
        100% { fill: #FFFFFF; }
    }
    
    @keyframes pixelGlow {
        0% { filter: brightness(1); }
        50% { filter: brightness(1.5); }
        100% { filter: brightness(1); }
    }
    
    .pixel {
        animation: pixelFade 2s ease-in-out forwards;
        animation-play-state: paused;
    }
    
    #app-loader[style*="display: flex"] .pixel {
        animation-play-state: running;
        animation-delay: var(--pixel-delay, 0s);
    }
    
    #g-loader {
        animation: pixelGlow 1s ease-in-out infinite;
    }

    /* Assign delays for sequential pixel animation */
    .pixel:nth-child(1) { --pixel-delay: 0.01s; }
    .pixel:nth-child(2) { --pixel-delay: 0.02s; }
    .pixel:nth-child(3) { --pixel-delay: 0.03s; }
    .pixel:nth-child(4) { --pixel-delay: 0.04s; }
    .pixel:nth-child(5) { --pixel-delay: 0.05s; }
    .pixel:nth-child(6) { --pixel-delay: 0.06s; }
    .pixel:nth-child(7) { --pixel-delay: 0.07s; }
    .pixel:nth-child(8) { --pixel-delay: 0.08s; }
</style>
<script>
    console.log("🔍 Checking if CodeMirror is loaded...");
    console.log("CodeMirror:", typeof CodeMirror !== "undefined" ? "✅ Loaded" : "❌ Not Found");
    if (typeof CodeMirror !== "undefined") {
        console.log("Available Modes:", CodeMirror.modes);
    }
</script>
</body>
</html>