/**
 * API client for LED Panel App Developer Platform
 */
class ApiClient {
    constructor() {
        this.baseUrl = '';
        this.csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';
    }
    
    async post(endpoint, data) {
        try {
            const response = await fetch(endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-Token': this.csrfToken
                },
                body: JSON.stringify(data)
            });
            
            return await response.json();
        } catch (error) {
            console.error('API Error:', error);
            throw error;
        }
    }
    
    async preview(code) {
        return this.post('api/preview.php', { code });
    }
    
    async save(data) {
        return this.post('api/save.php', data);
    }
}

// Initialize API client
window.api = new ApiClient();