<?php
require_once '../meekrodb.2.4.class.php';

$debug = true;

// Database credentials
DB::$user = 'passive1_cryptoguy';
DB::$password = '!e$QI}#!Dlw6';
DB::$dbName = 'passive1_crypto_service';

$stock_table = 'stock_list';
$total_stocks = DB::queryFirstField("SELECT COUNT(ID) FROM $stock_table WHERE ID > 1");
$batch_size = 50;
$total_batches = ceil($total_stocks / $batch_size);

if ($debug) {
    echo "<p>Total stocks: $total_stocks</p>";
    echo "<p>Total batches: $total_batches</p>";
}

// Process stocks in batches of 50, with a pause after every 6 batches
for ($batch_index = 0; $batch_index < $total_batches; $batch_index++) {
    $offset = $batch_index * $batch_size;
    $query = "SELECT ID, TICKER FROM $stock_table WHERE ID > 1 ORDER BY ID LIMIT $offset, $batch_size";
    $result = DB::query($query);

    $stock_array = [];
    foreach ($result as $row) {
        $stock_array[$row['TICKER']] = $row['ID'];
    }

    if ($debug) {
        echo "<p>Processing batch starting from index: $offset</p>";
    }

    $stockstring = implode(',', array_keys($stock_array));
    $api_key = 'your_api_key';
    $api_call = "https://api.twelvedata.com/time_series?apikey=$api_key&symbol=$stockstring&interval=1day&outputsize=2&format=json&dp=5";
    $api_call = cleanUrl($api_call);

    // Call the API
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $api_call,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET"
    ]);

    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        echo "cURL Error #: " . curl_error($curl);
        curl_close($curl);
        continue;
    }
    curl_close($curl);

    $response_data = json_decode($response, true);
    if (!$response_data || isset($response_data['code'])) {
        echo "Invalid API response";
        continue;
    }

    $con = mysqli_connect("localhost", "passive1_cryptoguy", "!e\$QI}#!Dlw6", "passive1_crypto_service");
    foreach ($response_data as $symbol => $data) {
        if (isset($stock_array[$symbol])) {
            $latest_close = $data['values'][0]['close'];
            $yesterday_close = $data['values'][1]['close'];
            $percent_diff = (($latest_close - $yesterday_close) / $yesterday_close) * 100;

            $query = "UPDATE `$stock_table` SET `Price`='$latest_close', `% Change`='$percent_diff' WHERE `Ticker`='$symbol'";
            mysqli_query($con, $query);
        }
    }

    // Pause execution after every 6 batches for 60 seconds to respect the API rate limit
    if (($batch_index + 1) % 6 == 0) {
        if ($debug) {
            echo "<p>Pausing for 60 seconds after batch " . ($batch_index + 1) . "...</p>";
        }
        sleep(60);
    }
}

if ($debug) {
    echo "<p>All batches processed.</p>";
}

function cleanUrl($url) {
    $url_parts = parse_url($url);
    parse_str($url_parts['query'], $params);
    $params['symbol'] = str_replace(" ", "", $params['symbol']);
    $params['symbol'] = preg_replace('/,,+/', ',', $params['symbol']);
    $url_parts['query'] = http_build_query($params);
    return $url_parts['scheme'] . '://' . $url_parts['host'] . $url_parts['path'] . '?' . $url_parts['query'];
}
?>
