<?php
header('Content-Type: application/json');

// Define leagues
$leagues = ['MLB', 'NBA', 'NCAAF', 'NFL', 'NHL'];

$result = [];

// Process each league - team leaders followed by player leaders
foreach ($leagues as $league) {
    // Team Leaders
    $teamEndpoint = 'TS_' . $league . '_OFF';
    $teamMapping = sprintf(
        'SS:192:32:create_team_ranks:PHP:Standings|%s:S',
        $teamEndpoint
    );
    
    $result[] = [
        'name' => $league . ' Team Leaders',
        'mapping' => $teamMapping,
    ];
    
    // Player Leaders
    $playerEndpoint = 'PS_' . $league . '_OFF';
    $playerMapping = sprintf(
        'SS:128:32:create_player_stats/%s:PHP:Standings|%s:S',
        $league,
        $playerEndpoint
    );
    
    $result[] = [
        'name' => $league . ' Player Leaders',
        'mapping' => $playerMapping,
    ];
}

// Output everything in a single response
echo json_encode($result, JSON_PRETTY_PRINT);